/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block.framed;

import com.jaquadro.minecraft.storagedrawers.api.framing.FrameMaterial;
import com.jaquadro.minecraft.storagedrawers.api.framing.IFramedBlock;
import com.jaquadro.minecraft.storagedrawers.api.framing.IFramedBlockEntity;
import com.jaquadro.minecraft.storagedrawers.api.storage.BlockType;
import com.jaquadro.minecraft.storagedrawers.block.BlockStandardDrawers;
import com.jaquadro.minecraft.storagedrawers.block.tile.BlockEntityDrawers;
import com.jaquadro.minecraft.storagedrawers.util.WorldUtils;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_4970;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockFramedStandardDrawers
extends BlockStandardDrawers
implements IFramedBlock {
    public BlockFramedStandardDrawers(int drawerCount, boolean halfDepth, int storageUnits, class_4970.class_2251 properties) {
        super(drawerCount, halfDepth, storageUnits, properties);
    }

    public BlockFramedStandardDrawers(int drawerCount, boolean halfDepth, class_4970.class_2251 properties) {
        super(drawerCount, halfDepth, properties);
    }

    @Override
    public BlockType retrimType() {
        return null;
    }

    @Override
    public void method_9567(@NotNull class_1937 world, @NotNull class_2338 pos, @NotNull class_2680 state, @Nullable class_1309 entity, @NotNull class_1799 stack) {
        super.method_9567(world, pos, state, entity, stack);
        BlockEntityDrawers blockEntity = WorldUtils.getBlockEntity((class_1922)world, pos, BlockEntityDrawers.class);
        if (blockEntity == null) {
            return;
        }
        class_2487 tag = stack.method_7948();
        blockEntity.material().read(tag);
        blockEntity.method_5431();
    }

    @Override
    protected class_1799 getMainDrop(class_2680 state, BlockEntityDrawers tile) {
        class_1799 drop = super.getMainDrop(state, tile);
        if (!tile.material().isEmpty()) {
            class_2487 tag = drop.method_7948();
            tile.material().write(tag);
            drop.method_7980(tag);
        }
        return drop;
    }

    public class_1799 method_9574(class_1922 level, class_2338 pos, class_2680 state) {
        class_1799 stack = super.method_9574(level, pos, state);
        BlockEntityDrawers tile = WorldUtils.getBlockEntity(level, pos, BlockEntityDrawers.class);
        if (tile != null && !tile.material().isEmpty()) {
            class_2487 data = stack.method_7948();
            tile.material().write(data);
            stack.method_7980(data);
        }
        return stack;
    }

    @Override
    public IFramedBlockEntity getFramedBlockEntity(@NotNull class_1937 world, @NotNull class_2338 pos) {
        return WorldUtils.getBlockEntity((class_1922)world, pos, BlockEntityDrawers.class);
    }

    @Override
    public boolean supportsFrameMaterial(FrameMaterial material) {
        return true;
    }
}

